
function toggleAnswer(element) {
    const answer = element.nextElementSibling;
    const isVisible = answer.style.display === 'block';

    // Hide all answers
    document.querySelectorAll('.faq-answer').forEach(answer => {
        answer.style.display = 'none';
    });

    // Show the clicked answer if it was not already visible
    if (!isVisible) {
        answer.style.display = 'block';
    }
}





$(document).ready(function() {
    var affiche_nb = false;

    $(window).scroll(function() {
        var scrollPosition = $(window).scrollTop();
        var numbersPosition = $('#numbers-container').offset().top - $(window).height() + 300;

        if (scrollPosition > numbersPosition && !affiche_nb) {
            affiche_nb = true;
            $('.number').each(function() {
                var $this = $(this);
                
                var countTo = $this.attr('data-number');
                $({ countNum: $this.text() }).animate(
                    { countNum: countTo },
                    {
                        duration: 2000,
                        easing: 'swing',
                        step: function() {
                            $this.text(Math.floor(this.countNum));
                        },
                        complete: function() {
                            $this.text(this.countNum);
                        }
                    }
                );
            });
        }
    });
});


